//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.0
import QtQuick.Controls 1.1
import QtQuick.Controls.Styles 1.1

import wesual.Controls 1.0

RadioButton {
    activeFocusOnTab   : true
    activeFocusOnPress : true

    property var data : null
    property int iconSize : 18
    property int pixelSize : 14

    // key handling
    Keys.onSpacePressed : checked = true

    style : RadioButtonStyle {
        label : Text {
            id : label

            width : implicitWidth + 4
            elide : Qt.ElideRight
            font {
                family : UI.fontFamily(UI.PrimaryFont)
                weight : UI.fontWeight(UI.PrimaryFont)
                pixelSize : pixelSize
            }
            color : enabled ?
                    UI.color(UI.PrimaryTextColor) : UI.color(UI.DisabledText)
            anchors.verticalCenter : parent.verticalCenter
            horizontalAlignment : Qt.AlignHCenter
            text : control.text

            Rectangle {
                id : focusBorder

                width  : parent.width
                height : iconSize

                border {
                    width : 1
                    color : UI.color(UI.PrimaryFocusBorder, 0.4)
                }
                color : UI.color(UI.PrimaryFocusBorder, 0.2)
                visible : control.activeFocus
                anchors.verticalCenter : parent.verticalCenter
            }
        }

        spacing : 4

        indicator : Rectangle {
            id : button

            implicitWidth  : iconSize
            implicitHeight : iconSize
            radius : width / 2
            color : UI.color(UI.PrimaryBase)
            border.color : UI.color(UI.PrimaryControlBorder)
            border.width : 1

            Image {
                id : icon

                anchors.verticalCenter   : parent.verticalCenter
                anchors.horizontalCenter : parent.horizontalCenter

                width  : iconSize
                height : iconSize

                sourceSize {
                    width  : iconSize
                    height : iconSize
                }

                source : "qrc:/controls/icons/radiobutton-circle.png"
                visible : control.checked
            }

            states : [
                State {
                    name : "disabled"
                    when : !control.enabled

                    changes : [
                        PropertyChanges {
                            target  : icon
                            visible : false
                        },
                        PropertyChanges {
                            target : button
                            color  : UI.color(UI.DisabledBorder)
                        }
                    ]
                },
                State {
                    name : "selected"
                    when : control.pressed

                    changes : [
                        PropertyChanges {
                            target : button
                            color  : UI.color(UI.PrimaryPress)
                        },
                        PropertyChanges {
                            target : button.border
                            color  : UI.color(UI.CheckBoxRadioButtonBorderPress)
                        }
                    ]
                },
                State {
                    name : "hovered"
                    when : control.hovered || control.activeFocus

                    changes : [
                        PropertyChanges {
                            target : button
                            color  : UI.color(UI.PrimaryHover)
                        },
                        PropertyChanges {
                            target : button.border
                            color  : UI.color(UI.CheckBoxRadioButtonBorderHover)
                        }
                    ]
                }
            ]

            Behavior on color {
                ColorAnimation {
                    duration : 0
                }
            }
            Behavior on border.color {
                ColorAnimation {
                    duration : 0
                }
            }
        }
    }
}
